local super = require "Control"

ListReorderTrack = super:new()

function ListReorderTrack:draw(canvas)
    local rect = self:rect()
    local insetRect = rect:inset{left = 0.5, right = 0.5, bottom = 0.5, top = 0.5}
    local path = Path.rect(rect, 5)
    local insetPath = Path.rect(insetRect, 4.5)
    
    -- draw outer highlight
    canvas:preserve(function(canvas)
        canvas:setThickness(1)
            :setPaint(self:highlightPaint())
            :concatTransformation(Transformation.identity():translate(0, -1))
            :clipRect{left = rect:minx(), right = rect:maxx(), bottom = rect:minx(), top = rect:midy()}
            :stroke(insetPath)
    end)
    
    -- draw background
    canvas:setPaint(self:fillPaint())
        :fill(path)
    
    -- draw inner shadow
    canvas:preserve(function(canvas)
        canvas:clip(path)
            :setPaint(self:shadowPaint())
            :setThickness(0.75)
            :stroke(insetPath)
    end)
end

function ListReorderTrack:fillPaint()
    if self:isActive() then
        return Color.gray(0.8)
    else
        return Color.gray(0.9)
    end
end

function ListReorderTrack:highlightPaint()
    if self:isActive() then
        return Color.gray(1, 0.25)
    else
        return Color.invisible
    end
end

function ListReorderTrack:shadowPaint()
    if self:isActive() then
        return Color.gray(0, 0.2)
    else
        return Color.gray(0, 0.1)
    end
end

return ListReorderTrack
